﻿var stratumEditor = {
    context: $(".v-stratumEditor"),
    initialize: function () {
        quotas.formatObjectiveInput();

        stratumEditor.context.on("click", ".h-useCriterionExpression", function () {
            $(".v-criterionPanel", stratumEditor.context).hide();
            $(".v-criterionExpressionPanel", stratumEditor.context).show();
        });

        stratumEditor.context.on("click", ".h-useCriterion", function () {
            $(".v-criterionPanel", stratumEditor.context).show();
            $(".v-criterionExpressionPanel", stratumEditor.context).hide();
        });

        stratumEditor.context.on("click", ".h-addConditionRow", function () {
            var contentPanel = $(this).closest(".content");
            contentPanel.scrollTop(contentPanel.height());
        });
        $("#Criterion", stratumEditor.context).prop("readonly", a4.parent().quotas.isInterviewerActive);
    },
    bindEvents: function () {
        this.context.on("click", ".h-submit", function () {
            var form = stratumEditor.context.parent("form");

            a4.appendAntiForgeryToken(form);

            if (a4.parent().quotas.isInterviewerActive) {
                modalDialog.showConfirmDialog(confirmAffectQuotasResources, function () {
                    form.submit();
                }, 250, 400);
            }
            else {
                form.submit();
            }
        });
    }
}

$(document).ready(function () {
    if (stratumEditor.context.length > 0) {
        stratumEditor.initialize();
        stratumEditor.bindEvents();
    }
});